<?php 
// ডেটাবেস সংযোগ এবং অন্যান্য প্রয়োজনীয় ফাইল অন্তর্ভুক্ত করুন
include '../includes/db.php'; 
?>

<?php include '../includes/header.php'; // হেডার ফাইল অন্তর্ভুক্ত করুন ?>
<?php include '../includes/sidebar.php'; // সাইডবার ফাইল অন্তর্ভুক্ত করুন ?>

<h1 class="mt-4">ভিডিও ম্যানেজমেন্ট</h1>

<!-- নতুন ভিডিও আপলোড করার ফর্ম -->
<div class="card my-4">
    <div class="card-header">
        নতুন ভিডিও আপলোড করুন
    </div>
    <div class="card-body">
        <form id="videoUploadForm" action="upload_video.php" method="post" enctype="multipart/form-data">
            
            <div class="form-group">
                <label for="title">ভিডিওর টাইটেল</label>
                <input type="text" name="title" id="title" class="form-control" placeholder="ভিডিওর একটি সুন্দর নাম দিন" required>
            </div>
            
            <div class="form-group">
                <label for="category_id">ক্যাটাগরি</label>
                <select name="category_id" id="category_id" class="form-control" required>
                    <option value="">-- ক্যাটাগরি নির্বাচন করুন --</option>
                    <?php
                    $cat_sql = "SELECT id, name FROM categories ORDER BY name ASC";
                    $cat_result = $conn->query($cat_sql);
                    if ($cat_result->num_rows > 0) {
                        while($cat_row = $cat_result->fetch_assoc()) {
                            echo "<option value='" . $cat_row['id'] . "'>" . htmlspecialchars($cat_row['name']) . "</option>";
                        }
                    }
                    ?>
                </select>
            </div>
            
            <div class="form-group">
                <label for="video_file">ভিডিও ফাইল (যেমন: MP4, AVI)</label>
                <input type="file" name="video_file" id="video_file" class="form-control-file" required>
            </div>

            <div class="form-group">
                <label for="thumbnail_file">ভিডিওর থাম্বনেইল (ছবি: JPG, PNG)</label>
                <input type="file" name="thumbnail_file" id="thumbnail_file" class="form-control-file" accept="image/*" required>
            </div>

            <button type="submit" class="btn btn-primary">আপলোড করুন</button>
        </form>
        
        <!-- আপলোড প্রোগ্রেস বার -->
        <div id="progressContainer" class="mt-3" style="display:none;">
            <div class="progress">
                <div id="progressBar" class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" style="width: 0%;" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div>
            </div>
            <div id="uploadStatus" class="text-center mt-1"></div>
        </div>
    </div>
</div>

<!-- বিদ্যমান ভিডিওর তালিকা দেখানোর টেবিল -->
<div class="card my-4">
    <div class="card-header">
        আপলোড করা ভিডিওসমূহ
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th style="width: 15%;">থাম্বনেইল</th>
                        <th>টাইটেল</th>
                        <th>ক্যাটাগরি</th>
                        <th style="width: 15%;">আপলোডের তারিখ</th>
                        <th style="width: 15%;">অ্যাকশন</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    // ডেটাবেস থেকে ভিডিও এবং ক্যাটাগরির তথ্য আনার জন্য SQL কোয়েরি
                    $sql_videos = "SELECT v.id, v.title, v.thumbnail_path, v.created_at, c.name AS category_name 
                                   FROM videos AS v 
                                   LEFT JOIN categories AS c ON v.category_id = c.id 
                                   ORDER BY v.id DESC";
                    $result_videos = $conn->query($sql_videos);

                    if ($result_videos->num_rows > 0) {
                        while($row = $result_videos->fetch_assoc()) {
                            echo "<tr>";
                            // থাম্বনেইল প্রদর্শন
                            echo "<td><img src='../" . htmlspecialchars($row['thumbnail_path']) . "' alt='" . htmlspecialchars($row['title']) . "' class='img-fluid img-thumbnail'></td>";
                            // টাইটেল
                            echo "<td>" . htmlspecialchars($row['title']) . "</td>";
                            // ক্যাটাগরির নাম
                            echo "<td>" . htmlspecialchars($row['category_name'] ?? 'N/A') . "</td>";
                            // আপলোডের তারিখ
                            echo "<td>" . date("d M, Y", strtotime($row['created_at'])) . "</td>";
                            // এডিট এবং ডিলিট বাটন
                            echo "<td>
                                    <a href='edit_video.php?id=" . $row['id'] . "' class='btn btn-sm btn-info mb-1'>এডিট</a>
                                    <a href='delete_video.php?id=" . $row['id'] . "' class='btn btn-sm btn-danger mb-1' onclick='return confirm(\"আপনি কি সত্যিই এই ভিডিওটি এবং এর সংশ্লিষ্ট ফাইলগুলো ডিলিট করতে চান?\")'>ডিলিট</a>
                                  </td>";
                            echo "</tr>";
                        }
                    } else {
                        // কোনো ভিডিও না থাকলে বার্তা প্রদর্শন
                        echo "<tr><td colspan='5' class='text-center'>এখনো কোনো ভিডিও আপলোড করা হয়নি।</td></tr>";
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; // ফুটার ফাইল অন্তর্ভুক্ত করুন ?>
<?php $conn->close(); // ডেটাবেস সংযোগ বন্ধ করুন ?>